
#include <string.h>
#include <stdlib.h>
#include <assert.h>
#include <math.h>
#include "../MachineInterface.h"

CMachineParameter const paraEffect = 
{ 
	pt_word,										// type
	"effect",
	"Fractal Effect",								// description
	0,												// MinValue	
	0xfffe,											// MaxValue
	0xffff,											// NoValue
	MPF_STATE,										// Flags
	0x8000,
};

CMachineParameter const paraDepth = 
{ 
	pt_byte,										// type
	"depth",
	"Fractal Depth",								// description
	0,												// MinValue	
	0x20,											// MaxValue
	0xff,											// NoValue
	MPF_STATE,										// Flags
	0x01
};


CMachineParameter const *pParameters[] = 
{ 
	// global
	&paraEffect,
	&paraDepth
};

#pragma pack(1)		

class gvals
{
public:
	word effect;
	byte depth;
};

#pragma pack()

CMachineInfo const MacInfo = 
{
	MT_EFFECT,								// type
	MI_VERSION,	
	0,										// flags
	0,										// min tracks
	0,										// max tracks
	2,										// numGlobalParameters
	0,										// numTrackParameters
	pParameters,
	0,
	NULL,
#ifdef _DEBUG
	"Ninereeds Fractal (Debug build)",		// name
#else
	"Ninereeds Fractal v1.0",					// name
#endif
	"Fractal",								// short name
	"Steve Horne",							// author
	NULL
};


class mi : public CMachineInterface
{
public:
	mi();
	virtual ~mi();

	virtual void Init(CMachineDataInput * const pi);
	virtual void Tick();
	virtual bool Work(float *psamples, int numsamples, int const mode);

private:
			
	

private:
	float Effect;
	float EffectB;
	float EffectA;
	int   Depth;
	
	gvals gval;

};

DLL_EXPORTS

mi::mi()
{
	GlobalVals = &gval;
//	AttrVals = (int *)&aval;
}

mi::~mi()
{
}

void mi::Init(CMachineDataInput * const pi)
{
	Effect = (((float) 32768) * 9.0) / ((float) 65534);

	EffectB = 3.0 - (3.0 * Effect);
	EffectA = 1.0 - (Effect + EffectB);

	Depth  = 1;
}

void mi::Tick()
{
	if (gval.effect != paraEffect.NoValue)
	{
		Effect = (((float) gval.effect) * 9.0) / ((float) 65534);
		EffectB = 3.0 - (3.0 * Effect);
		EffectA = 1.0 - (Effect + EffectB);
	}

	if (gval.depth != paraDepth.NoValue)
		Depth = gval.depth;
}


#define scale     (1.0 * 65536.0)
#define halfscale (0.5 * 65536.0)

bool mi::Work(float *psamples, int numsamples, int const mode)
{
	if (mode == WM_WRITE || mode == WM_NOIO)
		return false;
	
	if (mode == WM_READ  || Depth == 0 || Effect == 1.00)
		return true;

	float s;
	float ss;
	int   n;

	do
	{
		s = ((*psamples) + halfscale) / scale;
		n = Depth;

		while (n-- > 0)
		{
			ss = s * s;

			s =   (EffectA * ss * s)
				+ (EffectB * ss    )
				+ (Effect  * s     );
		}

		if (s < 0.0)
		{
			*psamples = -halfscale;
		}
		else if (s > 1.0)
		{
			*psamples = halfscale;
		}
		else
		{
			*psamples = (s * scale) - halfscale;
		}

		psamples++;
	} while (--numsamples);

	return true;
}


